unit ucMenu;

interface

uses System.Data, System.Drawing, System.Web, System.Web.UI,
     System.Web.UI.WebControls, System.Web.UI.HtmlControls,
     System.Collections;

type
    /// <summary>
    /// Summary description for WebUserControl1.
    /// </summary>


  TucMenu = class(System.Web.UI.UserControl)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
    Msg: System.Web.UI.WebControls.Label;
    dlMenu: System.Web.UI.WebControls.DataList;
    procedure OnInit(e: System.EventArgs); override;
  private
    { Private Declarations }
  public
    { Public Declarations }
  end;

implementation
uses Security, Helper, AdminDB;

procedure TucMenu.Page_Load(sender: System.Object; e: System.EventArgs);
var
  al : ArrayList;
  adminId : string;
  AdminDB : TAdminDB;
  AdminDetails : TAdminDetails;
begin
  if (TSecurity.IsAuthenticated) then
  begin
    adminId := Page.User.Identity.Name;

    AdminDB := TAdminDB.Create;
    AdminDetails := AdminDB.GetAdminDetails(adminId.ToString());

    if Assigned(Request.Cookies[THelper.CookieName]) then
      Msg.Text := 'Welcome ' + adminDetails.FullName.ToString + '!';
  end
  else
    Msg.Text := 'Please LogIn.';


  al := ArrayList.Create;
  if TSecurity.IsAuthenticated then
  begin
    al.Add(TLinkList.Create('Home', 'default.aspx?action=home'));
    al.Add(TLinkList.Create('Categories', 'default.aspx?action=categories'));
    al.Add(TLinkList.Create('Products', 'default.aspx?action=products'));
    al.Add(TLinkList.Create('Customers', 'default.aspx?action=customers'));
    al.Add(TLinkList.Create('Reviews', 'default.aspx?action=reviews'));
    al.Add(TLinkList.Create('Admins', 'default.aspx?action=admins'));
  end;

  dlMenu.DataSource := al;
  dlMenu.DataBind();
end;

procedure TucMenu.OnInit(e: System.EventArgs);
begin
  //
  // Required for Designer support
  //
  InitializeComponent;
  inherited OnInit(e);
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support -- do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TucMenu.InitializeComponent;
begin
  Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}




end.
